<?php
/* --------------------------------------------------------------
 SetSessionParameters.php 2020-02-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Kernel\Bootstrapper;

use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;
use Gambio\Core\Session\SessionNamePostfixGenerator;
use Gambio\Core\Session\SessionRepository;
use Gambio\Core\Session\SessionService;

/**
 * Class SetSessionParameters
 * @package Gambio\Core\Application\Kernel\Bootstrapper
 */
class SetSessionParameters extends AbstractBootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        /**
         * @var Path   $path
         * @var Url    $url
         */
        $path = $application->get(Path::class);
        $url  = $application->get(Url::class);
        
        $sessionRepository = new SessionRepository(new SessionNamePostfixGenerator(), $path);
        $sessionService    = new SessionService($sessionRepository, $url, $path);
        
        $sessionService->setupSession();
    }
}